
/////////////////////////////////////////////////////////
// general parameters

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;
float4x4	shader_light_view;
float4x4	shader_light_viewProj;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//material

float4		shader_material_diffuse;
float4		shader_material_ambient;
float4		shader_material_specular;
float		shader_material_eccentricity;
float		shader_material_transparency;
float		shader_material_reflectivity;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

/////////////////////////////////////////////////////////
// unique parameters

#define		SHADOW_EPSILON 0.0025f
float4x4	g_shadowerTransform;
float		g_light_farPlane;
float		shader_misc_shadow_mapSize;
float		shader_misc_shadow_mapTexelSize;
float		g_shadow_offset;

float3		cockpit_cameraPosition;
float3		cockpit_lightDirection;
float4x4	cockpit_cameraOrientation;

////////////////////////////////////////////////////////////////////
// structures

struct VS_INPUT
{
	float4 position		: POSITION;
	float3 normal		: NORMAL;
	float4 colour		: COLOR;
	float2 tex0			: TEXCOORD0;
};


struct VS_OUTPUT_HIGH
{
	float4 position		: POSITION;
	
	float3 normal		: TEXCOORD0;
	float2 tex0			: TEXCOORD1;
	float3 tex1			: TEXCOORD2;
	float4 diffuse		: COLOR0;
	float4 specular		: COLOR1;
};

////////////////////////////////////////////////////////////////////
// functions

VS_OUTPUT_HIGH vs_lighting_cockpit( VS_INPUT input )
{
	VS_OUTPUT_HIGH output = (VS_OUTPUT_HIGH) 0;

	output.position = mul(input.position, shader_transform_view);
	output.normal = normalize(mul(input.normal, (float3x3)shader_transform_view));
		
	float3 vCamera = normalize(output.position /*-shader_camera_eyePosition*/);
	float3 vHalfway = normalize(-cockpit_lightDirection - vCamera);
	
	output.specular = shader_material_specular.r * shader_light_specular.r * saturate(pow(dot( output.normal, vHalfway ), (1.0 / shader_material_eccentricity)*5));
	output.diffuse = float4(saturate(dot( output.normal, -cockpit_lightDirection )) * shader_light_diffuse.rgb,shader_material_transparency + output.specular.r);
	
	output.position = mul(output.position, shader_transform_proj);
 	
  	output.tex0 = input.tex0;
	
	output.normal = mul(output.normal, (float3x3) cockpit_cameraOrientation);
	output.tex1 = reflect( vCamera, output.normal );

	return output;
}

///////////////////////////////////////////////////////////////

sampler sample_colour_0 = sampler_state 
{ 
	Texture = (shader_texture_0);  
	MinFilter = LINEAR; 
	MagFilter = LINEAR;  
	MipFilter = LINEAR;  
};

sampler sample_colour_cube = sampler_state 
{ 
	Texture = (shader_texture_cubemap);  
	MinFilter = LINEAR; 
	MagFilter = LINEAR;  
};

///////////////////////////////////////////////////////////////

float4 ps_lighting_cockpit( VS_OUTPUT_HIGH input ) : COLOR0
{
	float4 textureColour = lerp( float4(shader_light_ambient.rgb + input.diffuse.rgb,1) * tex2D(sample_colour_0, input.tex0), float4(1,1,1,1), texCUBE(sample_colour_cube, input.tex1).r * shader_material_reflectivity);
	
	return shader_geometry_colour * float4(textureColour.rgb + input.specular, input.diffuse.a * (textureColour.a + input.specular.r ));
}

////////////////////////////////////////////////////////////

technique lighting_cockpit_11_20
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_lighting_cockpit();	
		PixelShader = compile ps_2_0 ps_lighting_cockpit();	
	}
}

technique lighting_cockpit_11_00
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_lighting_cockpit();	
	}
}